import os
from flask import Flask, current_app, redirect, url_for
from db import init_app, init_db
import wpisy
import users


app = Flask(__name__)

app.config.from_mapping(
    SECRET_KEY='dev',
    DATABASE=os.path.join(app.root_path, 'blog.db'),
    SITE_NAME='Blog'
)

init_app(app)
# rejestracja projektów
app.register_blueprint(wpisy.bp)
app.register_blueprint(users.bp)


@app.route('/')
def index():
    return redirect(url_for('wpisy.opublikowane'))


with app.app_context():
    if not os.path.exists(current_app.config['DATABASE']):
        init_db()
    if __name__ == "__main__":
        app.run(debug=True)
