DROP DATABASE IF EXISTS `szkola22`;
CREATE DATABASE `szkola22` CHARACTER SET = utf8 COLLATE = utf8_polish_ci;
USE `szkola22`;

DROP TABLE IF EXISTS `uczniowie`;
CREATE TABLE `uczniowie` (
  `id_ucz` int(11) NOT NULL AUTO_INCREMENT,
  `nazwisko` varchar(30) COLLATE utf8_polish_ci DEFAULT NULL,
  `imie` varchar(30) COLLATE utf8_polish_ci DEFAULT NULL,
  `ulica` varchar(50) COLLATE utf8_polish_ci DEFAULT NULL,
  `nr_domu` varchar(25) COLLATE utf8_polish_ci DEFAULT NULL,
  `klasa` char(2) COLLATE utf8_polish_ci DEFAULT NULL,
  PRIMARY KEY (`id_ucz`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

DROP TABLE IF EXISTS `przedmioty`;
CREATE TABLE `przedmioty` (
  `id_prz` int(11) NOT NULL AUTO_INCREMENT,
  `nazwa` varchar(20) COLLATE utf8_polish_ci DEFAULT NULL,
  `naucz_nazw` varchar(30) COLLATE utf8_polish_ci DEFAULT '',
  `naucz_imie` varchar(30) COLLATE utf8_polish_ci DEFAULT '',
  PRIMARY KEY (`id_prz`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

DROP TABLE IF EXISTS `oceny`;
CREATE TABLE `oceny` (
  `id_ucz` int(11) DEFAULT NULL,
  `ocena` decimal(2,1) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `id_prz` int(11) DEFAULT NULL,
  KEY `id_ucz` (`id_ucz`),
  KEY `id_prz` (`id_prz`),
  CONSTRAINT `oceny_ibfk_1` FOREIGN KEY (`id_ucz`) REFERENCES `uczniowie` (`id_ucz`),
  CONSTRAINT `oceny_ibfk_2` FOREIGN KEY (`id_prz`) REFERENCES `przedmioty` (`id_prz`)
) ENGINE=InnoDB COLLATE=utf8_polish_ci;
