from flask import (
    Blueprint, flash, render_template, request, redirect, url_for
)
from werkzeug.exceptions import abort
from db import get_db

bp = Blueprint('wpisy', __name__, url_prefix='/wpisy')


@bp.route('/')
def opublikowane():
    dane = get_db().execute('SELECT * FROM wpisy WHERE pokaz = 1').fetchall()
    if not dane:
        flash('Brak wpisów!')
    return render_template('wpisy_opublikowane.html', dane=dane)


@bp.route('/lista')
def lista():
    dane = get_db().execute('SELECT * FROM wpisy').fetchall()
    if not dane:
        flash('Brak wpisów!')
    return render_template('wpisy_lista.html', dane=dane)


@bp.route('/dodaj', methods=['GET', 'POST'])
def dodaj():
    if request.method == 'POST':
        tytul = request.form['tytul'].strip()
        tresc = request.form['tresc'].strip()
        pokaz = 1
        if 'pokaz' not in request.form:
            pokaz = 0
        db = get_db()
        db.execute('INSERT INTO wpisy VALUES (?, ?, ?, ?)', [None, tytul, tresc, pokaz])
        db.commit()
        flash(f'Dodano wpis: {tytul}')
        return redirect(url_for('wpisy.lista'))

    return render_template('wpis_dodaj.html')


def get_wpis(w_id):
    db = get_db()
    wpis = db.execute('SELECT * FROM wpisy WHERE id = ?', [w_id]).fetchone()
    if wpis is None:
        abort(404, f"Wpis o id {w_id} nie istnieje.")
    return wpis


@bp.route('/<int:w_id>/edytuj', methods=['GET', 'POST'])
def edytuj(w_id):
    rekord = get_wpis(w_id)
    if request.method == 'POST':
        tytul = request.form['tytul'].strip()
        tresc = request.form['tresc'].strip()
        pokaz = 1
        if 'pokaz' not in request.form:
            pokaz = 0
        db = get_db()
        db.execute('UPDATE wpisy SET tytul = ?, tresc = ?, pokaz = ? WHERE id = ?', [tytul, tresc, pokaz, w_id])
        db.commit()
        flash(f'Zaktualizowano wpis id {w_id} {tytul}.')
        return redirect(url_for('wpisy.lista'))

    return render_template('wpis_edytuj.html', rekord=rekord)


@bp.route('/<int:w_id>/usun', methods=['GET', 'POST'])
def usun(w_id):
    rekord = get_wpis(w_id)
    if request.method == 'POST':
        db = get_db()
        db.execute('DELETE FROM wpisy WHERE id = ?', [w_id])
        db.commit()
        flash(f'Usunięto wpis id {w_id} {rekord["tytul"]}')
        return redirect(url_for('wpisy.lista'))

    return render_template("wpis_usun.html", rekord=rekord)
