#include <iostream>
#include <thread>
#include <conio.h>
#include <fstream>
#include <time.h> 
using namespace std;

class Owoc
{
private:
	int liczbaPunktow = 0;
public:
	int sprawdzPunkty()
	{
		return this->liczbaPunktow;
	}

	void ustawPunkty(int liczbaPunktow)
	{
		this->liczbaPunktow = liczbaPunktow;
	}

	int ustawWynik(int liczbaPunktowDoUstawienia)
	{
		liczbaPunktow = liczbaPunktowDoUstawienia;
	}
};

class Waz
{
private:
	int liczbaPunktow = 0;
	int pozycjaWezaX = 0;
	int pozycjaWezaY = 0;
public:
	enum kierunek { polnoc = 0, wschod = 1, poludnie = 2, zachod = 3 };
	int kierunekRuchu = 0;

	int sprawdzWynik()
	{
		return liczbaPunktow;
	}

	int ustawWynik(int liczbaPunktowDoUstawienia)
	{
		liczbaPunktow = liczbaPunktowDoUstawienia;
	}

	void zmienKierunek(kierunek nowyKierunek)
	{
		kierunekRuchu = nowyKierunek;
	}

	void przesun(bool* watekGrafikiPracuje, bool* watekWazPracuje)
	{
		while (1)
		{
			while (*watekGrafikiPracuje)
			{
				this_thread::sleep_for(chrono::milliseconds(10));
			}
			*watekWazPracuje = true;
			if (kierunekRuchu == polnoc)
			{
				pozycjaWezaY -= 1;
			}
			else if (kierunekRuchu == poludnie)
			{
				pozycjaWezaY += 1;
			}
			else if (kierunekRuchu == zachod)
			{
				pozycjaWezaX += 1;
			}
			else if (kierunekRuchu == wschod)
			{
				pozycjaWezaX -= 1;
			}
			*watekWazPracuje = false;
			this_thread::sleep_for(chrono::milliseconds(400));
		}
	}

	int sprawdzPozycjeY()
	{
		return pozycjaWezaY;
	}

	int sprawdzPozycjeX()
	{
		return pozycjaWezaX;
	}

	void ustawPozycje(int x, int y)
	{
		pozycjaWezaX = x;
		pozycjaWezaY = y;
	}

	void zjedzOwoc(Owoc owoc)
	{
		liczbaPunktow += owoc.sprawdzPunkty();
	}
};

class Pole
{
public:
	Owoc owoc;
	int wartoscPola = 0;
};


class Plansza
{
public:
	int rozmiarXPlanszy;
	int rozmiarYPlanszy;
	Pole** pole;

	void losujPlansze()
	{
		srand((int)time(NULL));

		for (int i = 0; i < rozmiarYPlanszy; i++)
		{
			for (int j = 0; j < rozmiarXPlanszy; j++)
			{
				if ((rand() % 50) == 0)
				{
					pole[i][j].owoc.ustawPunkty(1);
				}
			}
		}
	}

	void zresetujPlansze()
	{

	}

	void zaaktualizujOgonWeza()
	{

	}

	Plansza(int rozmiarX, int rozmiarY)
	{
		rozmiarXPlanszy = rozmiarX;
		rozmiarYPlanszy = rozmiarY;

		pole = new Pole* [rozmiarYPlanszy];

		for (int i = 0; i < rozmiarYPlanszy; i++)
		{
			pole[i] = new Pole[rozmiarXPlanszy];
			for (int j = 0; j < rozmiarXPlanszy; j++)
			{
				pole[i][j] = Pole();
			}
		}
	}

	~Plansza()
	{
		for (int i = 0; i < rozmiarYPlanszy; ++i)
			delete[] pole[i];
		delete[] pole;
	}

};

class ObslugaWejscia
{
public:
	void zinterpretujWcisnietyPrzycisk(Waz* waz)
	{
		while (true)
		{
			char przycisk = getch();
			switch (przycisk)
			{
			case 'a':
				if (waz->kierunekRuchu == waz->polnoc)
					waz->kierunekRuchu = waz->wschod;
				else if (waz->kierunekRuchu == waz->wschod)
					waz->kierunekRuchu = waz->poludnie;
				else if (waz->kierunekRuchu == waz->poludnie)
					waz->kierunekRuchu = waz->zachod;
				else
					waz->kierunekRuchu = waz->polnoc;
				break;
			case 'd':
				if (waz->kierunekRuchu == waz->polnoc)
					waz->kierunekRuchu = waz->zachod;
				else if (waz->kierunekRuchu == waz->zachod)
					waz->kierunekRuchu = waz->poludnie;
				else if (waz->kierunekRuchu == waz->poludnie)
					waz->kierunekRuchu = waz->wschod;
				else
					waz->kierunekRuchu = waz->polnoc;
				break;
			case ' ':

				break;
			}
		}
	}
};

class WyswietlanieGrafiki
{
public:
	void wyswietlGre(Waz* waz, Plansza* plansza, bool* watekGrafikiPracuje, bool* watekWazPracuje)
	{
		while (true)
		{
			while (*watekWazPracuje)
			{
				this_thread::sleep_for(chrono::milliseconds(10));
			}
			*watekGrafikiPracuje = true;
			system("CLS");
			for (int i = 0; i < plansza->rozmiarYPlanszy; i++)
			{
				for (int j = 0; j < plansza->rozmiarXPlanszy; j++)
				{
					if (waz->sprawdzPozycjeY() == i && waz->sprawdzPozycjeX() == j)
						cout << "@ ";
					else if (plansza->pole[i][j].owoc.sprawdzPunkty() == 0)
						cout << "+ ";
					else
						cout << "$ ";
				}
				cout << endl;
			}
			*watekGrafikiPracuje = false;
			this_thread::sleep_for(chrono::milliseconds(200));
		}
	}
	WyswietlanieGrafiki()
	{

	}
};

int main()
{
	ifstream plikKonf("config.ini");
	int wartoscZmiennej;
	string zmienna;
	int rozmiarX = 0;
	int rozmiarY = 0;
	while (!plikKonf.eof())
	{
		if (plikKonf.is_open())
		{
			plikKonf >> zmienna >> wartoscZmiennej;
			if (zmienna == "wysokosc") rozmiarY = wartoscZmiennej;
			else if (zmienna == "szerokosc") rozmiarX = wartoscZmiennej;
		}
	}
	plikKonf.close();
	Plansza plansza = Plansza(rozmiarX, rozmiarY);
	plansza.losujPlansze();
	WyswietlanieGrafiki grafika = WyswietlanieGrafiki();
	Waz obiektWaz = Waz();
	obiektWaz.ustawPozycje(5, 15);
	bool watekWazPracuje = true;
	bool watekGrafikaPracuje = false;
	thread watekGrafiki(&WyswietlanieGrafiki::wyswietlGre, &grafika, &obiektWaz, &plansza, &watekWazPracuje, &watekGrafikaPracuje);
	ObslugaWejscia wejscie;
	thread watekWejscia(&ObslugaWejscia::zinterpretujWcisnietyPrzycisk, &wejscie, &obiektWaz);
	thread watekWeza(&Waz::przesun, &obiektWaz, &watekWazPracuje, &watekGrafikaPracuje);
	watekGrafiki.join();
	watekWejscia.join();
	watekWeza.join();
}
