USE mysql;
DROP DATABASE IF EXISTS uczniowie;
DROP USER IF EXISTS dyrektor;
CREATE DATABASE uczniowie CHARACTER SET = 'utf8' COLLATE = 'utf8_polish_ci';
GRANT USAGE ON *.* TO 'dyrektor'@'localhost' IDENTIFIED BY 'zaq1@WSX';
GRANT ALL PRIVILEGES ON uczniowie.* TO 'dyrektor'@'localhost';
FLUSH PRIVILEGES;
USE uczniowie;
DROP TABLE IF EXISTS uczniowie;
CREATE TABLE uczniowie (
	id CHAR(8) PRIMARY KEY,
	imie VARCHAR(20) NOT NULL CHECK(imie <> ''),
	nazwisko VARCHAR(30) NOT NULL CHECK(nazwisko <> ''),
	klasa CHAR(5) DEFAULT ''
);
DROP TABLE IF EXISTS przedmioty;
CREATE TABLE przedmioty (
	id INTEGER PRIMARY KEY AUTO_INCREMENT,
	nazwa VARCHAR(60) NOT NULL CHECK(nazwa <> '')
);
DROP TABLE IF EXISTS oceny;
CREATE TABLE oceny (
	id INTEGER PRIMARY KEY AUTO_INCREMENT,
	data DATE NOT NULL,
	id_ucz CHAR(8) NOT NULL,
	id_przedm INTEGER,
	ocena DECIMAL(3,2) NOT NULL CHECK(ocena < 7),
	FOREIGN KEY (id_ucz) REFERENCES uczniowie(id)
	ON DELETE CASCADE,
	FOREIGN KEY (id_przedm) REFERENCES przedmioty(id)
	ON DELETE SET NULL
);
