import processing.video.*;
import ddf.minim.*;

String ekran;
PImage intro;
PImage intro_glowny;
PImage ikona_wroc;
PImage ikona_wycisz;
PImage ikona_graj;
String miasto;
String opis;
int muzyka;
Minim minim;
AudioPlayer player;
Movie movieWroclaw;
Movie moviePoznan;
Movie movieLodz;
Movie movieKrakow;
Movie movieWarszawa;
Movie movieGdansk;

void setup() {
  size(700, 700); // ustawienie rozmiaru okna aplikacji
  intro = loadImage("grafika/intro.png");
  intro_glowny = loadImage("grafika/intro_napis.png");
  ikona_wroc = loadImage("grafika/ikona_wroc.png");
  ikona_wycisz = loadImage("grafika/ikona_wycisz.png");
  ikona_graj = loadImage("grafika/ikona_graj.png");
  miasto = "";
  ekran = "powitalny";
  opis = "";
  muzyka = 1;
  minim = new Minim(this);
  player = minim.loadFile("muzyka/music.mp3");
  player.play();
  movieWroclaw = new Movie(this, "video/Wroclaw.mp4");
  movieWroclaw.loop();
  moviePoznan = new Movie(this, "video/Poznan.mp4");
  moviePoznan.loop();
  movieLodz = new Movie(this, "video/Lodz.mp4");
  movieLodz.loop();
  movieKrakow = new Movie(this, "video/Krakow.mp4");
  movieKrakow.loop();
  movieWarszawa = new Movie(this, "video/Warszawa.mp4");
  movieWarszawa.loop();
  movieGdansk = new Movie(this, "video/Gdansk.mp4");
  movieGdansk.loop();
}

void ekran_powitalny(){ 
   background(255, 0, 0); 
   image(intro,0,0);
   textSize(20); 
   text("Kliknij myszką, aby rozpocząć", 100, 670); 
 }
 
void ekran_glowny(){ 
   background(255, 0, 0); 
   image(intro_glowny, 50, 100, 600, 600);
   color(0,0,0);
   textSize(20); 
   text("Wybierz miasto", 40, 650);
   textSize(50); 
   text(miasto,700/2 - textWidth(miasto)/2, 60);
 }
 
void ekran_miasta(String miasto){
    background(255, 0, 0);
    switch(miasto){
       case "Wrocław":
         image(movieWroclaw, 0, 50, 700, 300);
         opis = "Miasto na prawach powiatu w południowo-zachodniej Polsce.";
       break;
       case "Poznań":
         image(moviePoznan, 0, 50, 700, 300);
         opis = "Miasto na prawach powiatu w zachodniej Polsce.";
       break;
       case "Łódź":
         image(movieLodz, 0, 50, 700, 300);
         opis = "Miasto na prawach powiatu w środkowej Polsce.";
       break;
       case "Kraków":
         image(movieKrakow, 0, 50, 700, 300);
         opis = "Miasto na prawach powiatu położone w południowej Polsce nad Wisłą. \n" +
                "Formalna stolica Polski do 1795 roku i miasto koronacyjne wraz z nekropolią \n" + 
                "królów Polski na Wzgórzu Wawelskim.";
       break;
       case "Warszawa":
         image(movieWarszawa, 0, 50, 700, 300);
         opis = "Stolica Polski i województwa mazowieckiego.";
       break;
       case "Gdańsk":
         image(movieGdansk, 0, 50, 700, 300);
         opis = "Miasto na prawach powiatu w północnej Polsce.";
       break;
    }
    textSize(50);
    text(miasto,700/2 - textWidth(miasto)/2, 400);
    image(ikona_wroc,0,0);
    textSize(20);
    text(opis, 50, 450);
    
 }
 
 void movieEvent(Movie video){
    video.read(); 
 }
 
 void mousePressed(){
   switch(ekran){
     case "powitalny":
        ekran = "glowny"; 
     break;
     
     case "glowny":
       if(miasto != ""){
            ekran = "miasto";
       }
       if(mouseX > 650 && mouseY < 50){
            if(muzyka == 1){
               player.pause();
            }
            else if(muzyka == -1){
               player.play(); 
            }
            muzyka*=(-1);
       }
     break;
     
     case "miasto":
       if(mouseX < 50 && mouseY < 50){
          ekran = "glowny";
       }
     break;
   }
 }
 
 void mouseMoved(){ 
    if(ekran == "glowny"){
      if( mouseX > 140 && mouseX < 252 && mouseY > 392 && mouseY < 504) {
        miasto = "Wrocław";
      }
      else if( mouseX > 140 && mouseX < 252 && mouseY > 224 && mouseY < 336) {
        miasto = "Poznań";
      }
      else if( mouseX > 308 && mouseX < 420 && mouseY > 308 && mouseY < 420) {
        miasto = "Łódź";
      }
      else if( mouseX > 336 && mouseX < 448 && mouseY > 504 && mouseY < 616) {
        miasto = "Kraków";
      }
      else if( mouseX > 420 && mouseX < 532 && mouseY > 280 && mouseY < 392) {
        miasto = "Warszawa";
      }
      else if( mouseX > 224 && mouseX < 336 && mouseY > 112 && mouseY < 224) {
        miasto = "Gdańsk";
      }
      else {
        miasto = "";
      }
    }
 } 

void draw() {
  switch(ekran){
    case "powitalny":
      ekran_powitalny();
    break;
    case "glowny":
      ekran_glowny();
      if(muzyka == 1){
        image(ikona_graj, 650, 0);
      }
      else if(muzyka == -1){
        image(ikona_wycisz, 650, 0);
      }
    break;
    case "miasto":
      ekran_miasta(miasto);
    break;
  }
}
